cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

############################################################################
#########################	   read in data       ##########################
############################################################################

############ 2nd naive RNAseq
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1

n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24p","n24m","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:11],1,mean),apply(nfpkm2nd[,12:13],1,mean),apply(nfpkm2nd[,14:16],1,mean),apply(nfpkm2nd[,17:19],1,mean),apply(nfpkm2nd[,20:21],1,mean),apply(nfpkm2nd[,22:23],1,mean),apply(nfpkm2nd[,24:25],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)
nData <- log2(nData2ndfpkm+1)
############ 2nd primed RNAseq
pData2ndfpkm <- read.table("../data/paper.primed.fpkm.txt",header=T,row.names=1)
pData <- log2(pData2ndfpkm+1)

common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","iPSC-T")

############ genes
epiblast_gene <- as.matrix(read.table("../data/Epiblast_specific_genes.txt")[,1])
pesc_gene <- as.matrix(read.table("../data/Primed_hESC_specific_genes.txt")[,1])
epiblast_gene <- intersect(intersect(epiblast_gene,rownames(nData)),rownames(pData))
pesc_gene <- intersect(intersect(pesc_gene,rownames(nData)),rownames(pData))

############################################################################
#########################	   read in data       ##########################
############################################################################

pdf("DFig2.pdf",width=4,height=5)
par(mar=c(6,4,4,2))
epiblast_fc <- log2(nData2ndfpkm[epiblast_gene,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]/pData2ndfpkm[epiblast_gene,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")])
boxplot(epiblast_fc,col=cccol,main="epiblast specific genes",ylab="log2(naive/primed)",xaxt="n",ylim=c(-8,8),outline=F)
axis(side=1,1:length(common_time_point),common_time_point,las=2)
abline(h=0,lty=2)

pesc_fc <- log2(nData2ndfpkm[pesc_gene,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]/pData2ndfpkm[pesc_gene,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")])
boxplot(pesc_fc,col=cccol,main="primed hESC specific genes",ylab="log2(naive/primed)",xaxt="n",ylim=c(-8,8),outline=F)
axis(side=1,1:length(common_time_point),common_time_point,las=2)
abline(h=0,lty=2)
dev.off()